#version 330
#extension GL_EXT_gpu_shader4 : enable
//Sound TrackMod01.fsh by Passion
//https://www.shadertoy.com/view/3sjXDG
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define NUM_STEPS 100
#define FUDGE_AMOUNT 0.75
#define EPS 0.001
#define FAR 75.0

#define PI 3.1415926535898
vec3 sunCenter = vec3(1.0,1.0,0.2)*6.;
vec3 sunPeriph = vec3(1.0,0.3568,0.078)*5.;

vec3 sunEarthBottom = vec3(0.5)*4.;
vec3 sunEarthTop = vec3(0,0.49,0.69)*3.;

//void doScatter(inout vec3 dSC, inout vec3 sEC, in vec3 sp, in vec3 l, in vec3 r, in vec3 o);
// sebastien.hillaire.free.fr/demos/godray/godray.htm
void doScatter(inout vec3 dSC, inout vec3 sEC, in vec3 sp, in vec3 l, in vec3 r, in vec3 o){
    vec3 ctpn = normalize(sp-o);

    //direct sun color
    float directSun = dot(ctpn, normalize(l+r));
    directSun = pow( clamp(directSun,0.0,1.0), 125.0);

    // atmosphere
    float sunEarthScatering = 1.0-dot(ctpn, vec3(0.0,1.0,0.0));
    sunEarthScatering = pow( clamp(sunEarthScatering,0.0,1.0), 5.0);
    vec4 skyBlend = pow(1.*vec4(.1, .75, .8, 1), vec4(4.*(1.*r.y-.15)));
    sunEarthTop = 4.* pow(vec4(.1, .7, .8, 1).rgb, vec4(4.*max(r.y,-0.141)+1.5).rgb);

    // learp or mix based on directional lights 'y' coord/dir
    sunEarthTop = mix(.65*skyBlend.rgb, sunEarthTop, l.y);
    sunEarthBottom = mix(vec3(.5)*sunEarthBottom, sunEarthBottom, l.y);
    
    //lerp color and add contribution of sun and atmosphere
    dSC = mix(sunPeriph,sunCenter,directSun)*directSun;
    sEC = mix(sunEarthTop,sunEarthBottom,sunEarthScatering);
}

vec3 tri(in vec3 x){return abs(x-floor(x)-.5);} // Triangle function.

float surfFunc(in vec3 p){
	return dot(tri(p*0.5 + tri(p*0.25).yzx), vec3(0.777));
}

vec2 path(in float z){ float s = sin(z/34.)*cos(z/12.)*cos(sin(z/20.)); return vec2(s*20.+sin(s)*5.1, -2.25*s*15.); }

mat3 lookAtMatrix(vec3 origin, vec3 target, float roll) {
    vec3 rr = vec3(sin(roll), cos(roll), 0.0);
    vec3 ww = normalize(target - origin);
    vec3 uu = normalize(cross(ww, rr));
    vec3 vv = normalize(cross(uu, ww));

    return mat3(uu, vv, ww);
}

mat2 r2(float a){
    float s = sin(a);
    float c = cos(a);
    return mat2(s, -c, c, s);
}

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return length(max(d,0.0))
         + min(max(d.x,max(d.y,d.z)),0.0); // remove this line for an only partially signed sdf 
}

float sdRoundBox( vec3 p, vec3 b, float r )
{
  vec3 d = abs(p) - b;
  return length(max(d,0.0)) - r
         + min(max(d.x,max(d.y,d.z)),0.0); // remove this line for an only partially signed sdf 
}

float trackPlanks(vec3 tp){
    tp.xy = (tp.xy - path(tp.z))*vec2(0.5, 0.47071);
    tp.z = mod(tp.z, 1.) -0.5;
    float bmp2 = texture2D(iChannel1, tp.xz/4.).r*.015;
    return sdBox(vec3(tp.x,tp.y+1.4,tp.z), vec3(1., .05152, .2))+bmp2;
}
float trackRails(vec3 tp){
    tp.xy = (tp.xy - path(tp.z))*vec2(0.5, 0.47071);
    tp.z = mod(tp.z, 1.) -0.5;
    tp.x = abs(tp.x)-1.;
    return sdRoundBox(vec3(tp.x, tp.y+1.3, tp.z), vec3(.015, .015, .5), .12);
}
float map(vec3 p){
    float ground = p.y + (sin(sin(p.z*0.1253) - p.x*0.311)*1.31 + cos(p.z*0.53 + sin(p.x*0.127))*0.12)*1.7 + 0.2;
    ground += tri(p).y;
    float bmp = texture2D(iChannel0, p.xz/10.).r*.05;
    float tx = texture2D(iChannel3, p.xz/66. + p.xy/50., 0.0).x;

    ground+=bmp;

    vec2 tun = (p.xy - path(p.z))*vec2(0.5, 0.47071);
    float n = 1.- length(tun) + (0.5);
    n += surfFunc(p/2.);
    n+=tx;
      
    float planks = trackPlanks(p);
    float rails = trackRails(p);
        
    return min(min(max(ground, n), planks), rails);
}

float trace(vec3 o, vec3 r){
    float t = 0.0;
    for(int i = 0; i < NUM_STEPS; i++){
        float d = map(o+r*t);
        t += d * FUDGE_AMOUNT;
        if(abs(d) < EPS || t > FAR) break;
    }
    return t;
}
// Surface normal.
vec3 getNormal(in vec3 p) {
	
	const float eps = 0.001;
	return normalize(vec3(
		map(vec3(p.x + eps, p.y, p.z)) - map(vec3(p.x - eps, p.y, p.z)),
		map(vec3(p.x, p.y + eps, p.z)) - map(vec3(p.x, p.y - eps, p.z)),
		map(vec3(p.x, p.y, p.z + eps)) - map(vec3(p.x, p.y, p.z - eps))
	));

}
// Tri-Planar blending function. Based on an old Nvidia tutorial.
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n ){
  
    n = max((abs(n) - 0.2)*7., 0.001); // max(abs(n), 0.001), etc.
    n /= (n.x + n.y + n.z );  
    
	return (texture2D(tex, p.yz)*n.x + texture2D(tex, p.zx)*n.y + texture2D(tex, p.xy)*n.z).xyz;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    uv -= .5; uv.x *= iResolution.x / iResolution.y;
    vec3 r = normalize(vec3(uv, 1.0 - dot(uv, uv) * .33));
    vec3 o = vec3(0.0, 0.0, iTime*15.0);
    
    vec3 lookAt = o + vec3(0.0, -0.05,.245);
    o.xy += path(o.z);
    lookAt.xy +=path(lookAt.z);    
    
    mat3 camMat = lookAtMatrix(o, lookAt, -o.x/15.);  //clamp(o.x/3.,-.3,.3));
    r = normalize(camMat * r);
    
    float hit = trace(o, r);
    vec3 surfPos = o + r * hit;
    vec3 n = getNormal(surfPos);
    vec4 bg = vec4(0.0);
    vec3 l = normalize(vec3(0.1, 0.38+sin(iTime*.75)*.5, 0.4));
    l.xz *= r2(iTime*2.);
    float diff = max(dot(n,l), 0.25);
    
    float fog = smoothstep(01.175, 02.75, hit*0.03);
    gl_FragColor=vec4(0.0);
    
    float d = map(surfPos);
    float d2 = trackRails(surfPos);
    float d3 = trackPlanks(surfPos);
    vec3 rf = reflect(r,n);
    //vec3 cmp = texture2D(iChannel2, rf).rgb;
    
    vec3 directSunContrib = vec3(0.0);
    vec3 sunEarthContrib = vec3(0.0);
    doScatter(directSunContrib, sunEarthContrib, surfPos, l, r, o);
    
    bg = 0.25 * vec4( sunEarthContrib, 1.0);
    
    if(abs(d) < EPS+.4){
        vec3 tx= tex3D(iChannel0, surfPos/20., n);
        gl_FragColor = mix(vec4(tx, 1.0)*vec4(1.0*diff), bg, fog);        //+ hit* -.04;
        if(abs(d2)<EPS+.01)
            gl_FragColor = mix(vec4(vec3(.7, 0.4, 0.4), 1.0)*diff,bg,fog);  //
        else if(abs(d3) < EPS+0.1){
            vec4 tx = texture2D(iChannel1, surfPos.xz);
            gl_FragColor = mix(tx*diff,bg,fog);//*+vec4(0.2, 0.5, 0.3, 1.0)*diff*vec4(cmp,1.0);
        }
    }
    else
        gl_FragColor = vec4(0.25 * vec4( directSunContrib + sunEarthContrib, 1.0));
}